/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DumpRawFile {
    private static int read8(FileInputStream fis) throws IOException {
        byte[] buffer = new byte[1];
        int length = fis.read(buffer);
        if (length <= 0) {
            throw new IOException("EOF");
        }
        return buffer[0] & 0xFF;
    }

    private static int read32(FileInputStream fis) throws IOException {
        int n1 = DumpRawFile.read8(fis);
        int n2 = DumpRawFile.read8(fis);
        int n3 = DumpRawFile.read8(fis);
        int n4 = DumpRawFile.read8(fis);
        return n1 | n2 << 8 | n3 << 16 | n4 << 24;
    }

    private static void skip(FileInputStream fis, int length) throws IOException {
        fis.skip(length);
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream("tmp/xxDISCIDxx/Mpeg-nnnn/VideoStream-0.raw");
            boolean isVideo = true;
            int version = DumpRawFile.read32(fis);
            System.out.println(String.format("RawFile version %d", version));
            int frameCount = 0;
            while (true) {
                int fileSize = DumpRawFile.read32(fis);
                int timeStamp = DumpRawFile.read32(fis);
                if (isVideo) {
                    int packetsConsumed = DumpRawFile.read32(fis);
                    int totalBytes = DumpRawFile.read32(fis);
                    DumpRawFile.skip(fis, fileSize - 16);
                    System.out.println(String.format("VideoFrame %d, pts %d", frameCount, timeStamp, fileSize, packetsConsumed, totalBytes));
                } else {
                    DumpRawFile.skip(fis, fileSize - 8);
                    System.out.println(String.format("AudioFrame %d, pts %d", frameCount, timeStamp, fileSize));
                }
                ++frameCount;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

